// inproc.h : main header file for the INPROC application
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1993 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and Microsoft
// QuickHelp and/or WinHelp documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CInProcApp:
// See inproc.cpp for the implementation of this class
//

class CInProcApp : public CWinApp
{
public:
	CInProcApp();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CInProcApp)
	public:
	virtual BOOL InitInstance();
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CInProcApp)
	afx_msg void OnAppAbout();
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CVariant helper class

typedef const VARIANT* LPCVARIANT;

// a special class to wrap VARIANT
class CVariant : public tagVARIANT
{
public:
// Constructors
	CVariant()
		{ VariantInit(this); }
	CVariant(LPCVARIANT that)
		{ new (this) CVariant((const VARIANT&)*that); }
	CVariant(const CVariant& that)
		{ new (this) CVariant((const VARIANT&)that); }
	CVariant(const VARIANT& that);

// Operations
	BOOL operator==(const VARIANT& that) const;
	BOOL operator==(LPCVARIANT that) const
		{ return *this == *that; }
	void operator=(const VARIANT& that)
		{ VariantCopy(this, (LPVARIANT)&that); }
	void operator=(LPCVARIANT that)
		{ VariantCopy(this, (LPVARIANT)that); }
	void operator=(const CVariant& that)
		{ VariantCopy(this, (LPVARIANT)&that); }
	operator LPVARIANT()
		{ return this; }
	operator LPCVARIANT() const
		{ return this; }
	VARIANT Detach();

// Implementation
public:
	~CVariant()
		{ VariantClear(this); }
	void* operator new(size_t, void* here)
		{ return here; }
};

// special map class helpers
void SerializeElements(CArchive& ar, CVariant* pElements, int nCount);
void ConstructElements(CVariant* pElements, int nCount);
void DestructElements(CVariant* pElements, int nCount);
void DumpElements(CDumpContext& dc, CVariant* pElements, int nCount);
UINT HashKey(LPCVARIANT pVar);

#if (_MFC_VER >= 0x300)
// typedefs to simplify access to special map class
typedef CMap<CVariant, LPCVARIANT, CVariant, LPCVARIANT> CMapVariantToVariant;
#else
// use templdef generated class for CMapVariantToVariant implementation
#include "varmap16.h"
#endif

/////////////////////////////////////////////////////////////////////////////
